/*
    jklecmdefs.h  some useful constructs

    Copyright (C) 2015-2017  Oisin Robinson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

// Created on 18 February 2015, 21:39


#ifndef JKLECMDEFS_H
#define	JKLECMDEFS_H

#include <string>
#include <sstream>
#include <vector>

class expchain {
public:
    mpz_t S;
    unsigned long long L;
    expchain() {
        mpz_init(S);
    }
    ~expchain() {
        mpz_clear(S);
    }        
};

class epoint {
public:
    mpz_t x;
    mpz_t y;
    mpz_t z;
    epoint() {
        mpz_init(x);
        mpz_init(y);
        mpz_init(z);
    }
    epoint(mpz_t x0, mpz_t y0, mpz_t z0) {
        mpz_init_set(x, x0);
        mpz_init_set(y, y0);
        mpz_init_set(z, z0);
    }
    ~epoint() {
        mpz_clear(x);
        mpz_clear(y);
        mpz_clear(z);
    }
    void set(mpz_t x0, mpz_t y0, mpz_t z0) {
        mpz_set(x, x0);
        mpz_set(y, y0);
        mpz_set(z, z0);
    }
};

std::vector<std::string> &split(const std::string &s, char delim, std::vector<std::string> &elems) {
    std::stringstream ss(s);
    std::string item;
    while (std::getline(ss, item, delim)) {
        elems.push_back(item);
    }
    return elems;
}


std::vector<std::string> split(const std::string &s, char delim) {
    std::vector<std::string> elems;
    split(s, delim, elems);
    return elems;
}

long eulerphi(long n) {
    long a = n;
    long div = 2;
    long phi = n;
    long b;
    while (n != 1) {
        if (n % div != 0)
            div++;
        else {
            n = n / div;
            if (b != div) {
                b = div;
                phi = phi * (1.0 - 1.0 / div);
            }
        }
    }    
    return phi;
}

long gcd(long a, long b) {
    long c = a, d = b;
    while (true) {
        if (d == 0) break;
        long r = c % d;
        c = d;
        d = r;
    }
    return c;
}

int bitlength(long n) {
    int r = 1;
    while (n >>= 1) {
        r++;
    }
    return r;
}

#endif	/* JKLECMDEFS_H */

